#!/usr/bin/perl -w

$debug=1;

my $conf_dir = "/var/cache/awstats";        # location of  awstats062002.www.domain.ie.txt type files
my %vhosts; # key: vhost, value: last month done

use POSIX qw(strftime);
$nowM = strftime "%Y%m", localtime;

use Mysql;
# ----------------------------------------------------------
# --- Connect to MySQL                                   ---
# ----------------------------------------------------------
$db_host="localhost";
$db_data="hosting";
$db_user="postfix";
$db_pass="papagaj";
$db=Mysql->connect($db_host,$db_data,$db_user,$db_pass) or die "Couldn't connect to Mysql: ".Mysql->errmsg();

$q="SELECT vhost, MAX(mesiac) AS m FROM awstats_sum WHERE done='1' GROUP BY vhost";
$dbres=$db->query($q) or die "Couldn't fetch data (max-month) from Mysql: ".$db->errmsg();
while (@row = $dbres->fetchrow) {
  $vhosts{$row[0]} = $row[1];
}

opendir(DIR, $conf_dir);
while ($subdir = readdir(DIR)) {
  #d("\nGoing to process dir: $conf_dir/$subdir ...");
  next if ($subdir =~ /^\.{1,2}$/i);
  next unless -d "$conf_dir/$subdir";
  #d(" OK");
  opendir(SUBDIR, "$conf_dir/$subdir") or die("!opendir()");
  my @subfiles = grep { /^awstats.*\.txt$/ } readdir(SUBDIR);
  my $vhost=$subdir;
  my $lastM = defined $vhosts{$vhost} ? $vhosts{$vhost}:0;
  foreach $subfile (@subfiles) {
    $subfile = "$conf_dir/$subdir/" . $subfile;
    my $month = $subfile;
    $month =~ m~/awstats([0-9]{2})([0-9]{4})\.[^/]+$~;
    $month = $2.$1;
    print "$vhost: $month ";
    if ($month <= $lastM) {
      print "skipped\n";
      next;
    }
    print "processing...\n";
    process_file($subfile, $vhost, $month);
  }
  closedir(SUBDIR);
}
closedir(DIR);

######################################################### SUBs
sub process_file
{
  $f=$_[0];
  $vhost=$_[1];
  $month=$_[2];
  $sum = 0;

  $BEGIN_FOUND = $END_FOUND = 0;
  open(FILEIN, $f);
  while (<FILEIN>) {
   chomp;

  $BEGIN_FOUND = 1,next, if ($_ =~ /^BEGIN_TIME/);
  $END_FOUND = 1, if ($_ =~ /^END_TIME/);
  next ,if($BEGIN_FOUND == 0);
  last ,if($END_FOUND == 1);
  #print "$_<br>\n";
  my ($hour,$pages,$hits,$bandwidth,$nvpages,$nvhits,$nvbandwidth) = split(/\s/,$_,7);
  $sum += $bandwidth + $nvbandwidth;
 }
 close(FILEIN);
 #print "SUM: $sum\n";

 $done = ($nowM == $month) ? '0':'1';
 $q="UPDATE awstats_sum SET data='$sum',done='$done' WHERE (vhost=".$db->quote($vhost).") AND (mesiac='$month')";
 $dbresU=$db->query($q) or die "Error updating: ".$db->errmsg();
 if (!$dbresU->affectedrows) {
   $q ="INSERT IGNORE INTO awstats_sum (vhost,mesiac,data,done) VALUES(";
   $q.=$db->quote($vhost).", '$month', '$sum', '$done')";
   $dbres=$db->query($q) or die "Error inserting: ".$db->errmsg();
 }
}

sub d
{
print STDERR $_[0], if ($debug);
}
